% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est-c.r
\name{mn.ipw}
\alias{mn.ipw}
\title{Inverse probability weighted estimation of population means}
\usage{
mn.ipw(y, tr, fp)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} vector of outcomes with missing data.}

\item{tr}{An \eqn{n} x \eqn{1} vector of non-missing indicators (=1 if \code{y} is observed or 0 if \code{y} is missing).}

\item{fp}{An \eqn{n} x \eqn{1} vector of fitted propensity scores.}
}
\value{
\item{one}{The direct IPW estimate of 1.}
\item{est}{The ratio IPW estimate.}
}
\description{
This function implements inverse probability weighted (IPW) estimation of population means with missing data,
provided fitted propensity scores.
}
\details{
The ratio IPW estimate is the direct IPW estimate divided by that with \code{y} replaced by a vector of 1s. The latter is referred to as
the direct IPW estimate of 1.
}
\references{
Tan, Z. (2020a) Regularized calibrated estimation of propensity scores with model misspecification and high-dimensional data, \emph{Biometrika}, 107, 137–158.

Tan, Z. (2020b) Model-assisted inference for treatment effects using regularized calibrated estimation with high-dimensional data, \emph{Annals of Statistics}, 48, 811–837.
}
