% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.epid.R
\name{sim.epid}
\alias{sim.epid}
\title{Epidemic outbreak simulation}
\usage{
sim.epid(
  epid.nb,
  GT,
  R0,
  epid.length,
  family,
  negbin.size = NULL,
  peak.value = 50
)
}
\arguments{
\item{epid.nb}{Number of epidemics to be simulated (defaults to 1)}

\item{GT}{Generation time distribution from \code{\link[=generation.time]{generation.time()}}.}

\item{R0}{Basic reproduction number, in its core definition.}

\item{epid.length}{Maximum length of the epidemic (cases infected after this length will be truncated).}

\item{family}{Distribution of offspring. Can be either \code{"poisson"} (default) or \code{"negbin"}.}

\item{negbin.size}{If family is set to "negbin", sets the size parameter of the negative binomial distribution.}

\item{peak.value}{Threashold value for incidence before epidemics begins decreasing}
}
\value{
A matrix with epidemics stored as columns (incidence count).
}
\description{
Generates several epidemic curves with specified distribution and reproduction
number.
}
\details{
This function is only used for simulation purposes.
The output is a matrix of n columns (number of outbreaks) by m rows (maximum
length of an outbreak).

When using rnbinom with \code{mean} and \code{size} moments, the variance is given by
\code{mean + mean^2/size} (see \code{\link[stats:NegBinomial]{stats::rnbinom()}}). One should determine the size
accordingly to the R0 value to increase the dispersion. From the previous
formula for the variance, \eqn{Var(X) = k*R_{0}} implies that
\eqn{size = R0/(k-1)}.
}
\examples{
#Loading package
library(R0)

## In this example we simulate n=100 epidemic curves, with peak value at 150 incident cases, 
## and maximum epidemic length of 30 time units.
## Only the outbreak phase is computed. When the peak value is reached, the process is stopped 
## and another epidemic is generated.
sim.epid(epid.nb=100, GT=generation.time("gamma",c(3,1.5)), R0=1.5, 
         epid.length=30, family="poisson", peak.value=150)

# Here, a 30*100 matrix is returned. Each column is a single epidemic.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
