% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_tables.R
\name{table_group_fluorescence_linear}
\alias{table_group_fluorescence_linear}
\title{Generate a grouped results table for linear fits with average and standard deviations}
\usage{
table_group_fluorescence_linear(flTable, html = FALSE)
}
\arguments{
\item{flTable}{An object of class \code{flTable}}

\item{html}{(Logical) Should column headers contain html formatting?}
}
\value{
A data frame with grouped linear fit results. Empty cells indicate that no reliable fit could be determined.
}
\description{
Generate a grouped results table for linear fits with average and standard deviations
}
\examples{
\donttest{
# load example dataset
input <- read_data(data.growth = system.file("lac_promoters_growth.txt", package = "QurvE"),
                   data.fl = system.file("lac_promoters_fluorescence.txt", package = "QurvE"),
                   csvsep = "\t",
                   csvsep.fl = "\t")

# Run workflow
res <- fl.workflow(grodata = input, ec50 = FALSE, fit.opt = "l",
                   x_type = "time", norm_fl = TRUE,
                   dr.parameter = "max_slope.spline",
                   suppress.messages = TRUE,
                   parallelize = FALSE)

table_group_fluorescence_linear(res$flFit$flTable)

# with HTML formatting
DT::datatable(table_group_fluorescence_linear(res$flFit$flTable, html = TRUE),
              escape = FALSE) # Do not escape HTML entities
}
}
