% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_plots.R
\name{plot.gcBootSpline}
\alias{plot.gcBootSpline}
\title{Generic plot function for \code{gcBootSpline} objects.}
\usage{
\method{plot}{gcBootSpline}(
  x,
  pch = 1,
  colData = 1,
  deriv = TRUE,
  colSpline = "dodgerblue3",
  cex.point = 1,
  cex.lab = 1.5,
  cex.axis = 1.3,
  lwd = 2,
  y.lim = NULL,
  x.lim = NULL,
  y.lim.deriv = NULL,
  plot = TRUE,
  export = FALSE,
  height = 7,
  width = 9,
  out.dir = NULL,
  combine = FALSE,
  ...
)
}
\arguments{
\item{x}{object of class \code{gcBootSpline}, created with \code{\link{growth.gcBootSpline}}.}

\item{pch}{(Numeric) Symbol used to plot data points.}

\item{colData}{(Numeric or character) Contour color of the raw data circles.}

\item{deriv}{(Logical) Show the derivatives (i.e., slope) over time in a secondary plot (\code{TRUE}) or not (\code{FALSE}).}

\item{colSpline}{(Numeric or character) Spline line colour.}

\item{cex.point}{(Numeric) Size of the raw data points.}

\item{cex.lab}{(Numeric) Font size of axis titles.}

\item{cex.axis}{(Numeric) Font size of axis annotations.}

\item{lwd}{(Numeric) Spline line width.}

\item{y.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on y-axis of the growth curve plot as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{x.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the x-axis of both growth curve and derivative plots as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{y.lim.deriv}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the y-axis of the derivative plot as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{plot}{(Logical) Show the generated plot in the \code{Plots} pane (\code{TRUE}) or not (\code{FALSE}).}

\item{export}{(Logical) Export the generated plot as PDF and PNG files (\code{TRUE}) or not (\code{FALSE}).}

\item{height}{(Numeric) Height of the exported image in inches.}

\item{width}{(Numeric) Width of the exported image in inches.}

\item{out.dir}{(Character) Name or path to a folder in which the exported files are stored. If \code{NULL}, a "Plots" folder is created in the current working directory to store the files in.}

\item{combine}{(Logical) Indicate whether both growth curves and parameter plots shall be shown within the same window.}

\item{...}{Further arguments to refine the generated base R plot.}
}
\value{
A single plot with the all spline growth fits from the bootstrapping operation and statistical distribution of growth parameters if \code{combine = TRUE} or separate plots for growth fits and parameter distributions (if \code{combine = FALSE}).
}
\description{
Generic plot function for \code{gcBootSpline} objects.
}
\examples{
# Create random growth dataset
rnd.dataset <- rdm.data(d = 35, mu = 0.8, A = 5, label = "Test1")

# Extract time and growth data for single sample
time <- rnd.dataset$time[1,]
data <- rnd.dataset$data[1,-(1:3)] # Remove identifier columns

# Introduce some noise into the measurements
data <- data + stats::runif(97, -0.01, 0.09)

# Perform bootstrapping spline fit
TestFit <- growth.gcBootSpline(time, data, gcID = "TestFit",
              control = growth.control(fit.opt = "s", nboot.gc = 50))

plot(TestFit, combine = TRUE, lwd = 0.5)
}
