% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetAnalysis.R
\name{GetAnalysis}
\alias{GetAnalysis}
\title{Perform Statistical Analysis on Calculations}
\usage{
GetAnalysis(
  calculation_spread,
  control,
  test = "wilcox",
  alternative = "two.sided",
  adjust_p = FALSE,
  alpha = 0.05
)
}
\arguments{
\item{calculation_spread}{A list of data frames, each representing a calculation spread.

Output of \code{SpreadCaculation()}.}

\item{control}{The name or pattern of the control column in each data frame.}

\item{test}{The statistical test to use. Options are:
\itemize{
\item "t-test": Student's t-test, suitable for normally distributed data.
For more information, run: \code{?stats::t.test}
\item "wilcox": Wilcoxon rank-sum test (also known as Mann-Whitney U test), a non-parametric test.
For more information, run: \code{?stats::wilcox.test}
\item "yuen": Yuen's test for trimmed means, robust against outliers and non-normality.
For more information, run: \code{?WRS2::yuen}
}
Default is "wilcox".}

\item{alternative}{Options are "two.sided", "less", or "greater". Default is "two.sided".}

\item{adjust_p}{Logical. Whether to adjust p-values for multiple comparisons. Default is FALSE.}

\item{alpha}{The significance level for determining significance stars. Default is 0.05.}
}
\value{
A list of data frames containing the results of the statistical analysis for selected metrics.
}
\description{
This function performs statistical analysis on a list of calculation spreads,
comparing each column to a control column using various statistical tests.
}
\examples{
# Define the path to the plate data file
plate_path <- system.file("extdata/20240716_p3", 
                          file = '20240716_p3_plate.xlsx', 
                          package = "QuICSeedR")
  
# Read the plate data
plate <- readxl::read_xlsx(plate_path)

# Define the path to the raw data file
raw_path <- system.file("extdata/20240716_p3", 
                        file = '20240716_p3_raw.xlsx', 
                        package = "QuICSeedR")
# Read the raw data
raw <- readxl::read_xlsx(raw_path)

# Get replicate data
replicate <- GetReplicate(plate)

# Ensure time displayed as decimal hours
plate_time = ConvertTime(raw)

#Get metadata and display the few rows 
meta = CleanMeta(raw, plate, replicate)

#Clean data 
cleanraw <- CleanRaw(meta, raw, plate_time)

#Get calculations using positive controls to normalize values. 
calculation = GetCalculation(raw = cleanraw, meta, sd_fold = 10)

#Formatting calculations for analysis (also compatible with graphing 
#softwares used in F-SAA research)
calculation_spread = SpreadCalculation(calculation)

analysis <- GetAnalysis(calculation_spread, control = "Neg", test = "wilcox", 
                        alternative = 'greater')
head(analysis)

}
\references{
Mair, P., & Wilcox, R. (2020). WRS2: A Collection of Robust Statistical Methods.
https://CRAN.R-project.org/package=WRS2
}
