% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL.gCIMapping.R
\name{QTL.gCIMapping}
\alias{QTL.gCIMapping}
\title{QTL Genome-Wide Composite Interval Mapping}
\usage{
QTL.gCIMapping(
  file = NULL,
  fileFormat = "GCIM",
  filecov = NULL,
  MCIMmap = NULL,
  Population = NULL,
  method = "GCIM-QEI",
  MultiEnv = FALSE,
  Model = "Random",
  WalkSpeed = 1,
  CriLOD = 3,
  CriDis = 5,
  Likelihood = "REML",
  SetSeed = 11001,
  flagrqtl = FALSE,
  DrawPlot = TRUE,
  PlotFormat = "jpeg",
  Resolution = "Low",
  Trait = NULL,
  dir = NULL,
  CLO = NULL
)
}
\arguments{
\item{file}{File path and name in your computer.}

\item{fileFormat}{Format for input file: GCIM, ICIM, Cart, or MCIM.}

\item{filecov}{Covariate file of QTLIciMapping or QTLNetwork.}

\item{MCIMmap}{Map file of QTLNetwork.}

\item{Population}{Population type: F2, BC1, BC2, DH, RIL.}

\item{method}{Method "GCIM" or method "GCIM-QEI".}

\item{MultiEnv}{Whether to perform multi-environment analysis.}

\item{Model}{Random or fixed model.}

\item{WalkSpeed}{Walk speed for Genome-wide Scanning.}

\item{CriLOD}{Critical LOD scores for significant QTL.}

\item{CriDis}{The distance of optimization.}

\item{Likelihood}{This parameter is only for F2 population,including REML (restricted maximum likelihood ) and ML(maximum likelihood).}

\item{SetSeed}{In which the cross validation experiment is needed. Generally speaking, the random seed in the cross-validation experiment was set as 11001. If some known genes are not identified by the seed, users may try to use some new random seeds. At this case, one better result may be obtained.}

\item{flagrqtl}{This parameter is only for F2 population,   flagrqtl="FALSE" in the first running. If the other software detects only one QTL in a neighborhood but this software finds two linked QTLs (one with additive effect and another with dominant effect) in the region, let flagrqtl="TRUE"}

\item{DrawPlot}{This parameter is for all the populations, including FALSE and TRUE, DrawPlot=FALSE indicates no figure output, DrawPlot=TRUE indicates the output of the figure against genome position.}

\item{PlotFormat}{This parameter is for all the figure files, including *.jpeg, *.png, *.tiff and *.pdf.}

\item{Resolution}{This parameter is for all the figure files, including Low and High.}

\item{Trait}{Trait=1:3 indicates the analysis from the first trait to the third trait.}

\item{dir}{This parameter is for the save path.}

\item{CLO}{Number of CPUs.}
}
\description{
QTL Genome-Wide Composite Interval Mapping
}
\examples{
data(F2data)
QTL.gCIMapping(file=F2data,Population="F2",
MultiEnv=TRUE,Model="Random",CriLOD=3,
Trait=1,dir=tempdir(),CLO=2)
}
