% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.bandwidth.R
\name{cv.bandwidth}
\alias{cv.bandwidth}
\title{Cross-validation bandwidth}
\usage{
cv.bandwidth(y, x, z, dz, x0, val, xl, order, bdy)
}
\arguments{
\item{y}{a numeric vector, the outcome variable.}

\item{x}{the running variable.}

\item{z}{additional covariates.}

\item{dz}{the number of covariates z.}

\item{x0}{the cutoff point.}

\item{val}{a set of candidate values for the CV bandwidth.}

\item{xl}{if \emph{xl=0.5}, the CV bandwidth is computed using the 50\% of observations closest to \eqn{x_0}.}

\item{order}{either 1 or 2. When \emph{order=1}, a local linear regression is used, and
when \emph{order=2}, a local quadratic regression is used.}

\item{bdy}{either 0 or 1. When \emph{bdy=1}, the CV bandwidth is computed by
treating x as a boundary point. Otherwise, x is treated as an interior point.}
}
\value{
A list with elements:
\describe{
\item{h.cv}{the selected CV bandwidth values at the median.}
\item{cand}{values of the criterion function evaluated at each of candidate value.}
}
}
\description{
\code{cv.bandwidth} implements the cross-validation bandwidth selection rule. The function \code{rdq.bandwidth} calls this function to obtain the CV bandwidth.
}
\examples{
n = 500
x = runif(n,min=-4,max=4)
d = (x > 0)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + rnorm(n)
cv.bandwidth(y=y, x=x, z=NULL, dz=0, x0=0, val=c(1,2,3,4), xl=0.5, order=2, bdy=1)
cv.bandwidth(y=y, x=x, z=NULL, dz=0, x0=0, val=c(1,2,3,4), xl=0.5, order=1, bdy=1)

}
\references{
Zhongjun Qu, Jungmo Yoon, Pierre Perron (2024), "Inference on Conditional Quantile
Processes in Partially Linear Models with Applications to the Impact of Unemployment Benefits,"
The Review of Economics and Statistics; https://doi.org/10.1162/rest_a_01168

Zhongjun Qu and Jungmo Yoon (2019), "Uniform Inference on Quantile Effects
under Sharp Regression Discontinuity Designs," Journal of Business and Economic Statistics,
37(4), 625–647; https://doi.org/10.1080/07350015.2017.1407323
}
\seealso{
\link{rdq.bandwidth}
}
\keyword{internal}
