% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpdparameter.R
\name{hpdparameter}
\alias{hpdparameter}
\title{Highest Posterior Density (HPD) for a parameter}
\usage{
hpdparameter(parameter_MCMC, alpha = 0.05)
}
\arguments{
\item{parameter_MCMC}{a vector of the parameter samples for a single
estimated parameter}

\item{alpha}{100(1 - alpha)\% credible interval with the default value as
alpha = 0.05}
}
\value{
A vector is returned that contains the lower and upper bound of the
Highest Posterior Density (HPD) for a parameter (this will be the smallest
95\% credible interval using alpha = 0.05)
}
\description{
This function returns the upper and lower bound of the Highest
Posterior Density (HPD) for a parameter based on the Chen-Shao Highest
Posterior Density (HPD) Estimation Algorithm found in the book by Chen, Shao,
and Ibrahim (2000). (The smallest 95\% credible interval will be given by the
HPD using alpha = 0.05)
}
\examples{
x_parameter = rnorm(75, mean = 0, sd = 1)

hpdparameter(x_parameter, 0.05)
}
\references{
Chen M, Shao Q, Ibrahim JG (2000) Monte Carlo Methods in Bayesian
Computation. New York-New York: Springer-Verlag.
}
