% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-levey_jennings.R
\name{plot_levey_jennings}
\alias{plot_levey_jennings}
\title{Plot Levey-Jennings chart}
\usage{
plot_levey_jennings(
  list_of_plates,
  analyte_name,
  dilution = "1/400",
  sd_lines = c(1.96),
  data_type = "Median"
)
}
\arguments{
\item{list_of_plates}{A list of plate objects for which to plot the
Levey-Jennings chart}

\item{analyte_name}{(\code{character(1)}) the analyte for which to plot the
Levey-Jennings chart}

\item{dilution}{(\code{character(1)}) the dilution for which to plot the
Levey-Jennings chart. The default is "1/400"}

\item{sd_lines}{(\code{numeric}) the vector of coefficients for the
standard deviation lines to plot, for example, c(1.96, 2.58)
will plot four horizontal lines: mean +/- 1.96\emph{sd, mean +/- 2.58}sd
default is c(1.96) which will plot two lines mean +/- 1.96*sd}

\item{data_type}{(\code{character(1)}) the type of data used plot. The default is "Median"}
}
\value{
A ggplot object with the Levey-Jennings chart
}
\description{
The function plots a Levey-Jennings chart for the given analyte
in the list of plates. The Levey-Jennings chart is a graphical
representation of the data that enables the detection of outliers
and trends. It is a quality control tool that is widely used
in the laboratories across the world.
}
\examples{
# creating temporary directory for the example
output_dir <- tempdir(check = TRUE)

dir_with_luminex_files <- system.file("extdata", "multiplate_reallife_reduced",
  package = "PvSTATEM", mustWork = TRUE
)
list_of_plates <- process_dir(dir_with_luminex_files,
  return_plates = TRUE, format = "xPONENT", output_dir = output_dir
)
list_of_plates <- rep(list_of_plates, 10) # since we have only 3 plates i will repeat them 10 times

plot_levey_jennings(list_of_plates, "ME", dilution = "1/400", sd_lines = c(0.5, 1, 1.96, 2.58))

}
