% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileGLMM_Gibbs.R
\name{profileGLMM_Gibbs}
\alias{profileGLMM_Gibbs}
\title{R Wrapper for Profile GLMM Gibbs Sampler (C++ backend)}
\usage{
profileGLMM_Gibbs(model, nIt, nBurnIn)
}
\arguments{
\item{model}{An object of class \code{glmm_data} (the output of \code{profileGLMM_preprocess}).
This contains the design matrices, initial values, dimensions, and prior hyperparameters.}

\item{nIt}{Integer, the total number of MCMC iterations counting the burn-in period.
The sampler will return \code{nIt - nBurnIn} iterations in total.}

\item{nBurnIn}{Integer, the number of initial MCMC iterations that are discarded (not saved)
to allow the chain to converge.}
}
\value{
An object of class \code{pglmm_mcmc}. This is a list containing the saved Gibbs-sampled
MCMC chains for all model parameters (e.g., \code{beta}, \code{Z}, \code{gamma}, \code{pvec}, \code{muClus}, \code{PhiClus}, etc.)
and the variable names from the original data.
This output is intended for post-processing with \code{profileGLMM_postProcess}.
}
\description{
This is the main function for fitting the Profile Generalized Linear Mixed Model
using a blocked Gibbs sampling algorithm. It acts as an R wrapper, passing an object of class
\code{pglmm_data} directly to the RCPP implementation \code{GSLoopCPP}. The function simulates the
posterior distribution of all model parameters, including fixed effects, random effects variance,
profile cluster parameters, latent effects, and cluster assignments.
}
\examples{
# Load examp, which contains a pre-processed pglmm_data object
data("examp")
dataProfile = examp$dataProfile

# Run the Gibbs Sampler
MCMC_Obj = profileGLMM_Gibbs(
  model = dataProfile,
  nIt = 100,
  nBurnIn = 10
)
}
