% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findbeta_plot.R
\name{plot.PriorGen}
\alias{plot.PriorGen}
\title{The findbeta plot function}
\usage{
\method{plot}{PriorGen}(x, ...)
}
\arguments{
\item{x}{An object of type findbeta produces of one of
the other PriorGen functions.}

\item{...}{More basic plot arguments}
}
\description{
A function that plots any object of the class findbeta.
}
\examples{
## Example 1
## Based on the available literature the mean value for the 
## sensitivity of a test is expected to be generally low and 
## its variance not that low but not that much neither.

res_abs_1 <- findbeta_abstract(
  themean.cat = "Low",
  thevariance.cat = "Average"
)
plot(res_abs_1,
  main = "Plot of the findbeta_abstract function",
  lwd = 3, ylim = c(0, 7)
)

## Example 2
## Hierarchical prior

res_mult_1 <- findbetamupsi(
  themean = 0.10, percentile = 0.79,
  lower.v = TRUE, percentile.value = 0.26, psi.percentile = 0.95,
  percentile.median = 0.28, percentile95value = 0.3
)

plot(res_mult_1,
  main = "Plot of the findbetamupsi function",
  lwd = 3, ylim = c(0, 7)
)

}
