% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poped_optim_2.R
\name{poped_optim_2}
\alias{poped_optim_2}
\title{Optimization main module for PopED}
\usage{
poped_optim_2(
  poped.db,
  opt_xt = poped.db$settings$optsw[2],
  opt_a = poped.db$settings$optsw[4],
  opt_x = poped.db$settings$optsw[3],
  opt_samps = poped.db$settings$optsw[1],
  opt_inds = poped.db$settings$optsw[5],
  method = c("ARS", "BFGS", "LS"),
  control = list(),
  trace = TRUE,
  fim.calc.type = poped.db$settings$iFIMCalculationType,
  ofv_calc_type = poped.db$settings$ofv_calc_type,
  approx_type = poped.db$settings$iApproximationMethod,
  d_switch = poped.db$settings$d_switch,
  ED_samp_size = poped.db$settings$ED_samp_size,
  bLHS = poped.db$settings$bLHS,
  use_laplace = poped.db$settings$iEDCalculationType,
  out_file = "",
  parallel = F,
  parallel_type = NULL,
  num_cores = NULL,
  loop_methods = ifelse(length(method) > 1, TRUE, FALSE),
  iter_max = 10,
  stop_crit_eff = 1.001,
  stop_crit_diff = NULL,
  stop_crit_rel = NULL,
  ofv_fun = poped.db$settings$ofv_fun,
  maximize = T,
  transform_parameters = F,
  ...
)
}
\arguments{
\item{poped.db}{A PopED database.}

\item{opt_xt}{Should the sample times be optimized?}

\item{opt_a}{Should the continuous design variables be optimized?}

\item{opt_x}{Should the discrete design variables be optimized?}

\item{opt_samps}{Are the number of sample times per group being optimized?}

\item{opt_inds}{Are the number of individuals per group being optimized?}

\item{method}{A vector of optimization methods to use in a sequential 
fashion.  Options are \code{c("ARS","BFGS","LS","GA")}. \code{c("ARS")} is 
for Adaptive Random Search \code{\link{optim_ARS}}.  \code{c("LS")} is for 
Line Search \code{\link{optim_LS}}. \code{c("BFGS")} is for Method 
"L-BFGS-B" from \code{\link[stats]{optim}}. \code{c("GA")} is for the 
genetic algorithm from \code{\link[GA]{ga}}.}

\item{control}{Contains control arguments for each method specified.}

\item{trace}{Should the algorithm output results intermittently.}

\item{fim.calc.type}{The method used for calculating the FIM. Potential values:
\itemize{
\item 0 = Full FIM.  No assumption that fixed and random effects are uncorrelated.  
\item 1 = Reduced FIM. Assume that there is no correlation in the FIM between the fixed and random effects, and set these elements in 
the FIM to zero. 
\item 2 = weighted models (placeholder).
\item 3 = Not currently used.
\item 4 = Reduced FIM and computing all derivatives with respect to the standard deviation of the residual unexplained variation (sqrt(SIGMA) in NONMEM). 
This matches what is done in PFIM, and assumes that the standard deviation of the residual unexplained variation is the estimated parameter
(NOTE: NONMEM estimates the variance of the residual unexplained variation by default). 
\item 5 = Full FIM parameterized with A,B,C matrices & derivative of variance. 
\item 6 = Calculate one model switch at a time, good for large matrices. 
\item 7 = Reduced FIM parameterized with A,B,C matrices & derivative of variance.
}}

\item{ofv_calc_type}{OFV calculation type for FIM 
\itemize{ 
\item 1 = "D-optimality". Determinant of the FIM: det(FIM)
\item 2 = "A-optimality".  Inverse of the sum of the expected parameter variances: 
1/trace_matrix(inv(FIM)) 
\item 4 = "lnD-optimality".  Natural logarithm of the determinant of the FIM: log(det(FIM)) 
\item 6 = "Ds-optimality". Ratio of the Determinant of the FIM and the Determinant of the uninteresting
rows and columns of the FIM: det(FIM)/det(FIM_u)
\item 7 = Inverse of the sum of the expected parameter RSE: 1/sum(get_rse(FIM,poped.db,use_percent=FALSE))
}}

\item{approx_type}{Approximation method for model, 0=FO, 1=FOCE, 2=FOCEI, 3=FOI.}

\item{d_switch}{\itemize{
\item \bold{******START OF CRITERION SPECIFICATION OPTIONS**********}}
D-family design (1) or ED-family design (0) (with or without parameter uncertainty)}

\item{ED_samp_size}{Sample size for E-family sampling}

\item{bLHS}{How to sample from distributions in E-family calculations. 0=Random Sampling, 1=LatinHyperCube --}

\item{use_laplace}{Should the Laplace method be used in calculating the expectation of the OFV?}

\item{out_file}{Save output from the optimization to a file.}

\item{parallel}{Should we use parallel computations?}

\item{parallel_type}{Which type of parallelization should be used? 
Can be "snow" or "multicore".  "snow"  works on Linux-like systems & Windows. "multicore" works only on 
Linux-like systems.  By default this is chosen for you depending on your operating system. 
See \code{\link{start_parallel}}.}

\item{num_cores}{The number of cores to use in the parallelization.  By default  is set to the number 
 output from 
\code{parallel::detectCores()}. 
See \code{\link{start_parallel}}.}

\item{loop_methods}{Should the optimization methods be looped for
\code{iter_max} iterations, or until the efficiency of the design after the
current series (compared to the start of the series) is less than, or equal to,
\code{stop_crit_eff}?}

\item{iter_max}{If line search is used then the algorithm tests if line
search (always run at the end of the optimization iteration) changes the 
design in any way.  If not, the algorithm stops.  If yes, then a new
iteration is run unless \code{iter_max} iterations have already been run.}

\item{stop_crit_eff}{If \code{loop_methods==TRUE}, the looping will stop if the
efficiency of the design after the current series (compared to the start of
the series) is less than, or equal to, \code{stop_crit_eff} (if \code{maximize==FALSE} then 1/stop_crit_eff is the cut
off and the efficiency must be greater than or equal to this value to stop the looping).}

\item{stop_crit_diff}{If \code{loop_methods==TRUE}, the looping will stop if the
difference in criterion value of the design after the current series (compared to the start of
the series) is less than, or equal to, \code{stop_crit_diff} (if \code{maximize==FALSE} then -stop_crit_diff is the cut
off and the difference in criterion value must be greater than or equal to this value to stop the looping).}

\item{stop_crit_rel}{If \code{loop_methods==TRUE}, the looping will stop if the
relative difference in criterion value of the design after the current series (compared to the start of
the series) is less than, or equal to, \code{stop_crit_rel} (if \code{maximize==FALSE} then -stop_crit_rel is the cut
off and the relative difference in criterion value must be greater than or equal to this value to stop the looping).}

\item{ofv_fun}{User defined function used to compute the objective function. The function must have a poped database object as its first
argument and have "..." in its argument list.  Can be referenced as a function or as a file name where the function defined in the file has the same name as the file.
e.g. "cost.txt" has a function named "cost" in it.}

\item{maximize}{Should the objective function be maximized or minimized?}

\item{transform_parameters}{Should we transform the parameters before optimization?}

\item{...}{arguments passed to other functions.}
}
\description{
Optimize the objective function. The function works for both discrete and 
continuous optimization variables. If more than one optimization method is 
specified then the methods are run in series.  If \code{loop_methods=TRUE} 
then the series of optimization methods will be run for \code{iter_max} 
iterations, or until the efficiency of the design after the current series 
(compared to the start of the series) is less than \code{stop_crit_eff}.
}
\details{
This function takes information from the PopED database supplied as an 
argument. The PopED database supplies information about the the model, 
parameters, design and methods to use. Some of the arguments coming from the 
PopED database can be overwritten; if they are supplied then they are used 
instead of the arguments from the PopED database.
}
\references{
\enumerate{ \item M. Foracchia, A.C. Hooker, P. Vicini and A. 
  Ruggeri, "PopED, a software fir optimal experimental design in population 
  kinetics", Computer Methods and Programs in Biomedicine, 74, 2004. \item J.
  Nyberg, S. Ueckert, E.A. Stroemberg, S. Hennig, M.O. Karlsson and A.C. 
  Hooker, "PopED: An extended, parallelized, nonlinear mixed effects models 
  optimal design tool", Computer Methods and Programs in Biomedicine, 108, 
  2012. }
}
\seealso{
Other Optimize: 
\code{\link{Doptim}()},
\code{\link{LEDoptim}()},
\code{\link{RS_opt}()},
\code{\link{a_line_search}()},
\code{\link{bfgsb_min}()},
\code{\link{calc_autofocus}()},
\code{\link{calc_ofv_and_grad}()},
\code{\link{mfea}()},
\code{\link{optim_ARS}()},
\code{\link{optim_LS}()},
\code{\link{poped_optim}()},
\code{\link{poped_optim_1}()},
\code{\link{poped_optim_3}()},
\code{\link{poped_optimize}()}
}
\concept{Optimize}
\keyword{internal}
