% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_transform.R
\name{linear_transform}
\alias{linear_transform}
\title{Best Linear Transformations}
\usage{
linear_transform(
  x,
  l0 = rep(1, ncol(x)),
  method = "both",
  epsilon = 1e-10,
  iter = 5000,
  stepsize = 0.001
)
}
\arguments{
\item{x}{multivariate data matrix.}

\item{l0}{starting point for projection algorithm,
default is \code{rep(1, ncol(x))}.}

\item{method}{character strings,
one of \code{c("skewness", "kurtosis", "both")}.}

\item{epsilon}{bounds on error of optimal solution, default is \code{1e-10}.}

\item{iter}{number of iteration of projection algorithm,
default is \code{5000}.}

\item{stepsize}{gradient descent stepsize, default is \code{.001}.}
}
\value{
\itemize{
\item{\code{max_result}: The maximum value after linear transformation.}
\item{\code{x_uni}: Univariate data after transformation.}
\item{\code{vector_k}: Vector of the "best" linear transformation.}
\item{\code{error}: Error of projection algorithm.}
\item{\code{iteration}: Number of iteration. }
}
}
\description{
The algorithm uses gradient descent algorithm to obtain the maximum of the
square of sample skewness, of the kurtosis or of their average under any
univariate linear transformation of the multivariate data.
}
\examples{
set.seed(1)
x <- MASS::mvrnorm(100, mu = rep(0, 2), diag(2))
linear_transform(x, method = "skewness")$max_result
linear_transform(x, method = "kurtosis")$max_result
linear_transform(x, method = "both")$max_result
}
\seealso{
\code{\link[=skewness]{skewness()}},
\code{\link[=kurtosis]{kurtosis()}}
}
