% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{stats}
\alias{stats}
\title{Representativeness and confidence statistics for a forest inventory}
\usage{
stats(obj, area.tot, prob = 0.95, shape.factor = 1, rm.dead = FALSE)
}
\arguments{
\item{obj}{An object of class \code{param} created by \code{\link{phytoparam}}.
Must contain the raw data (\code{obj$data}), variable mappings (\code{obj$vars}),
and global inventory metadata (\code{obj$global}).}

\item{area.tot}{Total habitat area (in hectares) to which estimates will be
extrapolated (e.g., the whole forest fragment). \strong{Required}.}

\item{prob}{Confidence level used to compute \emph{t}-based confidence limits
(default \code{0.95}).}

\item{shape.factor}{Stem form correction factor used in the individual volume
calculation (\eqn{V_i = abi \times h \times shape.factor}). Default \code{1}
(cylindrical shape).}

\item{rm.dead}{Logical. If \code{TRUE}, dead trees are excluded from all
calculations (rows whose taxon label matches the “dead” code stored in
\code{obj$vars}).}
}
\value{
A list with three components:
\itemize{
  \item \code{inventory}: data frame summarizing inventory coverage
    (fields \code{Stat} and \code{Values}).
  \item \code{ha}: data frame of per-hectare statistics for stand parameters
    (fields \code{Stat}, \code{ADe}, \code{AVol}, \code{ABA}).
  \item \code{population}: data frame of population-level statistics for the
    total area (\code{area.tot}), including required numbers of SUs for
    \code{10\%} and \code{20\%} permissible errors.
}
}
\description{
Computes representativeness and confidence statistics for a forest inventory.
Summarizes inventory coverage, estimates absolute stand parameters per hectare
with uncertainty (density, volume, basal area), and extrapolates results to the
total habitat area, including sample-size requirements for target permissible errors.
}
\details{
Extracts the sample-unit (SU) identifier, taxon label, height/length variable,
and “dead” code from \code{obj$vars}, and the surveyed (inventoried) area from
\code{obj$global}. If \code{rm.dead = TRUE}, individuals flagged as dead are
removed before analysis.

Individual volume is computed as \eqn{V_i = abi \times h \times shape.factor},
where \code{abi} and \code{h} are columns present in \code{obj$data}. Per-SU
totals of volume and basal area are converted to per-hectare values using the
SU area. The function then derives, for density (ADe), volume (AVol), and basal
area (ABA):
\itemize{
  \item mean, variance, standard deviation, standard error;
  \item coefficient of variation (CV);
  \item absolute and relative sampling error (based on the \emph{t} quantile with \code{|SU| - 1} df);
  \item lower and upper confidence limits per hectare.
}

Inventory representativeness (total area, number/area of SUs, and percentage inventoried)
is reported, and population totals (for \code{area.tot}) are produced with corresponding
confidence limits. Required numbers of SUs to attain \code{10\%} and \code{20\%} permissible
relative errors are computed from standard finite-population sampling formulae.
}
\note{
\itemize{
  \item Representativeness is reported both as inventoried area (ha) and as
  percentage of the total area.
  \item The number of SUs required for a target permissible error depends on the
  observed variance, the SU area, and the chosen confidence level (\code{prob}).
}
}
\examples{
## Creating the param object containing the phytosociological parameters
quadrat.param <- phytoparam(x = quadrat.df, measure.label = "CBH",
                            taxon = "Species", dead = "Morta", family = "Family",
                            circumference = TRUE, su = "Plot", height = TRUE,
                            su.size = 25, rm.dead = FALSE)

## Calculating the statistics
stats(obj = quadrat.param, area.tot = 4)

}
\references{
FAO (1981). \emph{Manual of Forest Inventory—With Special Reference to Mixed Tropical Forests}.
Food and Agriculture Organization of the United Nations, Rome.
}
\author{
Rodrigo Augusto Santinelo Pereira \email{raspereira@usp.br}
}
