% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_selection.R
\name{feature_selection}
\alias{feature_selection}
\title{Feature Selection for Spectral Data}
\usage{
feature_selection(
  file_path,
  output_path = "selected_features.xlsx",
  fdr_threshold = 0.01
)
}
\arguments{
\item{file_path}{Path to the cleaned dataset (output of qaqcs function).}

\item{output_path}{Path to save the selected features table.}

\item{fdr_threshold}{Threshold for filtering significant features (default: 0.01).}
}
\value{
A data.table containing selected spectral variables.
}
\description{
This function filters healthy vs diseased samples, selects the most discriminative spectral variables,
applies FDR correction, and exports the results.
}
\examples{
# Create mock spectral data
library(openxlsx)
mock_data <- data.frame(
  treatment = sample(0:1, 100, replace = TRUE),
  var1 = rnorm(100),
  var2 = rnorm(100),
  var3 = rnorm(100)
)
temp_file <- tempfile(fileext = ".xlsx")
write.xlsx(mock_data, temp_file)

# Perform feature selection
output_path <- tempfile(fileext = ".xlsx")
selected_features <- feature_selection(temp_file, output_path, fdr_threshold = 0.01)
head(selected_features)
}
