
<p align="center">
  <img src="man/figures/logo.png" alt="Bayer CropScience Logo" width="1000">
</p>

<p align="center">
  <img src="man/figures/logo2.jpg" alt="One Field Solutions Logo" width="500">
</p>

# PhenoSpectra

<p align="left">
  <img src="man/figures/logo3.jpg" alt="One Field Solutions Logo" width="250">
</p>


PhenoSpectra is an R package designed for processing, analyzing, and visualizing spectral data collected from 3D laser-based scanning systems. This package supports data from various domains, including agriculture, forestry, environmental monitoring, industrial quality control, and biomedical research.

## Key Features

- **Data Handling**:
  - Automated reading, merging, and preprocessing of spectral datasets.
  - Splitting timestamp columns into separate date and time components.
  - Group-based assignment of biological replicates (`Bio.Rep`).

- **Quality Control**:
  - Detection of missing values and outliers.
  - Flexible handling of irregularities with options to replace, remove, or impute data.
  - Group-specific outlier detection using statistical methods.

- **Feature Selection & Prediction**:
  - Selection of the most discriminative spectral variables using FDR correction.
  - Prediction of Spectral Disease Severity (SDS) using linear regression models.

- **Customizable Workflow**:
  - Supports group-based analyses for treatments or other categorical variables.
  - Generates clean, publication-ready datasets and summary reports.

## Installation

To install the **PhenoSpectra** package directly from GitHub:

1. Ensure you have the `devtools` package installed:
   ```R
   install.packages("devtools")
   ```

2. Install **PhenoSpectra**:
   ```R
   devtools::install_github("bayer-int/PhenoSpectra")
   ```

## File Structure

Below is an overview of the directory structure of the PhenoSpectra package:

- **R**: R functions (e.g., reads.R, qaqcs.R, feature_selection.R, predict_SDS.R)
- **man**: Documentation files (auto-generated by Roxygen2)
- **data**: Example datasets (if applicable)
- **Demo**: Demo input/output files for testing functions
- **DESCRIPTION**: Package metadata
- **NAMESPACE**: Package imports and exports
- **README.md**: Project overview and usage
- **LICENSE**: Licensing information
- **inst**: Installation-related files (if required)
- **vignettes**: Extended examples and tutorials (if applicable)

## Usage Examples

### 1. Using `reads()`

```R
merged_data <- reads(
  directory = "Demo",
  pattern = "input",
  output_path = "Demo/processed_data.xlsx"
)
```

### 2. Using `qaqcs()`

```R
result <- qaqcs(
  file_path = "Demo/raw_data.xlsx",
  output_path = "Demo/cleaned_data.xlsx",
  handle_missing = "impute",
  handle_outliers = "impute",
  group_by_col = "treatment"
)

# Access the cleaned data and summary table
cleaned_data <- result$cleaned_data
summary_table <- result$summary_table
```

### 3. Using `feature_selection()`

```R
selected_features <- feature_selection(
  file_path = "Demo/cleaned_data.xlsx",
  output_path = "Demo/selected_features.xlsx",
  fdr_threshold = 0.01
)

# View the selected features
print(selected_features)
```

### 4. Using `predict_SDS()`

```R
predicted_sds <- predict_SDS(
  cleaned_data = cleaned_data,
  sf_test = selected_features,
  fixed_effects = c("Scan.date")
)

# View predictions
print(predicted_sds)
```

## License

This project is licensed under the MIT License. See the `LICENSE` file for more details.

## Contact

<p align="left">
  <strong style="font-size: 1.2em; color: #005691;">Dr. Medhat Mahmoud,</strong><br>
  <span style="color: #333333;">Statistical Scientist</span><br>
  <span style="color: #333333;">Decision Pipeline & Analytics</span><br>
  <hr style="border: none; height: 3px; background: repeating-linear-gradient(90deg, #00a2e8, #00a2e8 10px, transparent 10px, transparent 20px);">
  <strong style="color: #000000;">Bayer CropScience AG</strong><br>
  Research & Development<br>
  Field Solutions<br>
  Alfred-Nobel-Straße 50<br>
  40789 Monheim am Rhein<br>
  <strong>Mobile:</strong> +49 15901499490<br>
  <strong style="color: #005691;">E-mail:</strong> <a href="mailto:medhat.mahmoud@bayer.com" style="color: #005691;">medhat.mahmoud@bayer.com</a><br>
  <strong style="color: #005691;">GitHub:</strong> <a href="https://github.com/Medhat-Mahmoud" style="color: #005691;">https://github.com/Medhat-Mahmoud</a><br>
  <strong style="color: #005691;">Web:</strong> <a href="https://agrar.bayer.de/" style="color: #005691;">https://www.bayercropscience.de</a>
</p>
