% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reward_phase_type.R
\name{reward_phase_type}
\alias{reward_phase_type}
\title{Transformation of Phase-Type Distributions via Rewards}
\usage{
reward_phase_type(phase_type, reward)
}
\arguments{
\item{phase_type}{an object of class \code{cont_phase_type} or
\code{disc_phase_type}.}

\item{reward}{a vector of the same length as the number of
states. The vector should contain non-negative values. Rewards for the
discrete phase-type distribution can only be integers.}
}
\value{
An object of class \code{disc_phase_type} or \code{cont_phase_type}.
}
\description{
Transform a variable following a phase-type distribution according to a
non-negative reward vector.
}
\details{
For the reward transformation for continuous phase-type distribution, the
transformation will be performed as presented in the book of Bladt and
Nielsen (2017).

For the discrete phase_type distribution is based on the PhD of Navarro (2018) and
Hobolth, Bladt and Andersen (2021).
}
\examples{
##===========================##
## For continuous phase-type ##
##===========================##

subint_mat <- matrix(c(-3, 1, 1,
                      2, -3, 0,
                      1, 1, -3), ncol = 3)
init_probs <- c(0.9, 0.1, 0)
ph <- PH(subint_mat, init_probs)
reward <- c(0.5, 0, 4)

reward_phase_type(ph, reward)

##=========================##
## For discrete phase-type ##
##=========================##

subint_mat <- matrix(c(0.4, 0, 0,
                      0.24, 0.4, 0,
                      0.12, 0.2, 0.5), ncol = 3)
init_probs <- c(0.9, 0.1, 0)
ph <- DPH(subint_mat, init_probs)

reward <- c(1, 0, 4)

reward_phase_type(ph, reward)


}
\references{
Bladt, M., & Nielsen, B. F. (2017). *Matrix-exponential distributions in applied probability* (Vol. 81). New York: Springer.

Campillo Navarro, A. (2018). *Order statistics and multivariate discrete phase-type distributions*. DTU Compute. DTU Compute PHD-2018, Vol.. 492

Hobolth, A., Bladt, M. & Andersen, L.A. (2021). *Multivariate phase-type theory for the site frequency spectrum*. ArXiv.
}
\seealso{
\code{\link{PH}}, \code{\link{DPH}}
}
