\name{run_bootstrap_E_hat}
\alias{run_bootstrap_E_hat}
\title{Bootstrap for Nuisance Function Estimation}
\description{
  Runs bootstrap replications to estimate the nuisance quantity
  \eqn{E[Y - D \theta]} using double machine learning, and returns the
  bootstrap distribution (mean and variance) of the estimate.
}
\usage{
run_bootstrap_E_hat(D, X, Y, B, ml_f, ml_g)
}
\arguments{
  \item{D}{Treatment variable(s); matrix.}
  \item{X}{Design matrix.}
  \item{Y}{Outcome variable.}
  \item{B}{Number of bootstrap replications.}
  \item{ml_f}{Outcome learner for DoubleML.}
  \item{ml_g}{Treatment learner for DoubleML.}
}
\value{
  A list with components:
  \item{E_hat}{Numeric vector of length B: bootstrap estimates.}
  \item{E_hat_mean}{Mean of \code{E_hat}.}
  \item{E_hat_var}{Variance of \code{E_hat}.}
}
\seealso{
  \code{\link{boot_detection}}
}
