\name{RMSE}
\alias{RMSE}
\title{Root Mean Squared Error}
\description{
  Computes the root mean squared error of parameter estimates across
  simulations: for each component, \eqn{\sqrt{\mathrm{mean}((\hat{\theta} - \theta)^2)}}.
}
\usage{
RMSE(Theta, Theta.hat)
}
\arguments{
  \item{Theta}{True parameter vector; \eqn{p \times 1}.}
  \item{Theta.hat}{Matrix of estimates; \eqn{p \times n_{sim}}.}
}
\value{
  Numeric vector of length \code{p}: RMSE per parameter component.
}
\examples{
  th <- c(1, 2)
  th_hat <- matrix(c(1.1, 2.2, 0.9, 1.8), nrow = 2)
  RMSE(th, th_hat)
}
\seealso{
  \code{\link{DGP}}, \code{\link{fit_PTL}}, \code{\link{fit_HPTL}}
}
