% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matched_set_obj.R
\name{print.matched.set}
\alias{print.matched.set}
\title{Print matched.set objects.}
\usage{
\method{print}{matched.set}(x, ..., verbose = FALSE, n = 5, show.all = FALSE)
}
\arguments{
\item{x}{a \code{matched.set} object}

\item{...}{Not used. additional arguments to be passed to \code{print}}

\item{verbose}{logical indicating whether or not output should be printed in expanded/raw list form. The verbose form is not recommended unless the data set is small. Default is FALSE, which prints an overview of matched set sizes.}

\item{n}{Integer. Integer. Number of matched sets to display information about as a preview. Default is 5.}

\item{show.all}{Logical. By default (`show.all = FALSE`), the print method only shows a small preview of the sizes of matched sets. When set to TRUE, a full summary description of matched set sizes is shown.}
}
\value{
Returns nothing, but prints information about matched sets: treated observation IDs, the time of treatment, and the size of matched sets.
}
\description{
Print matched.set objects.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
# create subset of data for simplicity
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
PM.results <- PanelMatch(panel.data = dem.sub.panel, lag = 4,
                        refinement.method = "ps.match",
                        match.missing = TRUE,
                        covs.formula = ~ tradewb,
                        size.match = 5, qoi = "att",
                        lead = 0:4,
                        forbid.treatment.reversal = FALSE)
print(extract(PM.results, qoi = "att"))



}
