#' @title Population by nationality, age group, sex and rural/urban
#' @name   TABLE_10
#' @docType data
#' @keywords datasets
#' @usage data(TABLE_10)
#' @description \code{TABLE_10} Population by nationality, age group, sex and rural/urban
#' @format A \code{data.table} and  \code{data.frame}.
#' \describe{
#'   \item{\code{PROVINCE}}{PROVINCE}
#'   \item{\code{DIVISION}}{DIVISION}
#'   \item{\code{DISTRICT}}{DISTRICT}
#'   \item{\code{AGE_GROUP}}{AGE GROUP}
#'   \item{\code{NATIONALITY}}{NATIONALITY}
#'   \item{\code{OVERALL_ALL_SEXES}}{OVERALL ALL SEXES}
#'   \item{\code{RURAL_ALL_SEXES}}{RURAL ALL SEXES}
#'   \item{\code{URBAN_ALL_SEXES}}{URBAN ALL SEXES}
#'   \item{\code{OVERALL_FEMALE}}{OVERALL FEMALE}
#'   \item{\code{RURAL_FEMALE}}{RURAL FEMALE}
#'   \item{\code{URBAN_FEMALE}}{URBAN FEMALE}
#'   \item{\code{OVERALL_MALE}}{OVERALL MALE}
#'   \item{\code{RURAL_MALE}}{RURAL MALE}
#'   \item{\code{URBAN_MALE}}{URBAN MALE}
#'   \item{\code{OVERALL_TGEND}}{OVERALL TRANSGENDER}
#'   \item{\code{RURAL_TGEND}}{RURAL TRANSGENDER}
#'   \item{\code{URBAN_TGEND}}{URBAN TRANSGENDER}
#'        }
#'
#' @author Muhammad Yaseen (\email{myaseen208@@gmail.com})
#'
#' @references \enumerate{
#' \item Pakistan Population Census 2023 (\url{https://www.pbs.gov.pk/}).
#'  }
#' 
#' @seealso
#'    \code{\link{PakPC2023PakDiv}}
#'  , \code{\link{PakPC2023PakDist}}
#'
#' @import DT htmltools
#' 
#' @examples
#' data(TABLE_10)
NULL
