% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{predict.ptsr}
\alias{predict.ptsr}
\title{Predict method for PTSR}
\usage{
\method{predict}{ptsr}(object, newdata, nnew = 0, ...)
}
\arguments{
\item{object}{Object of class inheriting from \code{"ptsr"}}

\item{newdata}{A matrix with new values for the regressors.   If omitted
and \code{"xreg"} is present in the model, the fitted values are returned.
If the model does not include regressors, the functions will use
the value of \code{nnew}.}

\item{nnew}{number of out-of-sample forecasts required. If \code{newdata} is
provided, \code{nnew} is ignored.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list with the following arguments

 \item{series}{The original time series yt.}

 \item{xreg}{The original regressors (if any).}

 \item{fitted.values}{The in-sample forecast given by \eqn{\mu_t}.}

 \item{etat}{In-sample values of \eqn{g(\mu[t])}.}

 \item{error}{The error term}

 \item{residuals}{The (in-sample) residuals, that is, the observed minus the
 predicted values.}

 \item{forecast}{The predicted values for yt.}
}
\description{
Predicted values based on ptsr object.
}
\details{
\code{predict.ptsr} produces predicted values, obtained by evaluating
  the regression function in the frame \code{newdata}.

  If \code{newdata} is omitted the predictions are based on the data
  used for the fit.

  For now, prediction intervals are not provided.
}
