% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfit-S3methods.R
\name{plot.PLNnetworkfit}
\alias{plot.PLNnetworkfit}
\title{Extract and plot the network (partial correlation, support or inverse covariance) from a \code{\link{PLNnetworkfit}} object}
\usage{
\method{plot}{PLNnetworkfit}(
  x,
  type = c("partial_cor", "support"),
  output = c("igraph", "corrplot"),
  edge.color = c("#F8766D", "#00BFC4"),
  remove.isolated = FALSE,
  node.labels = NULL,
  layout = layout_in_circle,
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{an R6 object with class \code{\link{PLNnetworkfit}}}

\item{type}{character. Value of the weight of the edges in the network, either "partial_cor" (partial correlation) or "support" (binary). Default is \code{"partial_cor"}.}

\item{output}{the type of output used: either 'igraph' or 'corrplot'. Default is \code{'igraph'}.}

\item{edge.color}{Length 2 color vector. Color for positive/negative edges. Default is \code{c("#F8766D", "#00BFC4")}. Only relevant for igraph output.}

\item{remove.isolated}{if \code{TRUE}, isolated node are remove before plotting. Only relevant for igraph output.}

\item{node.labels}{vector of character. The labels of the nodes. The default will use the column names ot the response matrix.}

\item{layout}{an optional igraph layout. Only relevant for igraph output.}

\item{plot}{logical. Should the final network be displayed or only sent back to the user. Default is \code{TRUE}.}

\item{...}{Not used (S3 compatibility).}
}
\value{
Send back an invisible object (igraph or Matrix, depending on the output chosen) and optionally displays a graph (via igraph or corrplot for large ones)
}
\description{
Extract and plot the network (partial correlation, support or inverse covariance) from a \code{\link{PLNnetworkfit}} object
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
fits <- PLNnetwork(Abundance ~ 1, data = trichoptera)
myNet <- getBestModel(fits)
\dontrun{
plot(myNet)
}
}
