% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covtest.clx.R
\name{covtest.clx}
\alias{covtest.clx}
\title{Two-sample high-dimensional covariance test (Cai, Liu and Xia, 2013)}
\usage{
covtest.clx(dataX,dataY)
}
\arguments{
\item{dataX}{an \eqn{n_1} by \eqn{p} data matrix}

\item{dataY}{an \eqn{n_2} by \eqn{p} data matrix}
}
\value{
\code{stat} the value of test statistic

\code{pval} the p-value for the test.
}
\description{
This function implements the two-sample \eqn{l_\infty}-norm-based
high-dimensional covariance test proposed in Cai, Liu and Xia (2013).
Suppose \eqn{\{\mathbf{X}_1, \ldots, \mathbf{X}_{n_1}\}} are i.i.d.
copies of \eqn{\mathbf{X}}, and \eqn{\{\mathbf{Y}_1, \ldots, \mathbf{Y}_{n_2}\}}
are i.i.d. copies of \eqn{\mathbf{Y}}. The test statistic is defined as
\deqn{T_{CLX} = \max_{1\leq i,j \leq p} \frac{(\hat\sigma_{ij1}-\hat\sigma_{ij2})^2}
{\hat\theta_{ij1}/n_1+\hat\theta_{ij2}/n_2},}
where \eqn{\hat\sigma_{ij1}} and \eqn{\hat\sigma_{ij2}} are the sample covariances,
and \eqn{\hat\theta_{ij1}/n_1+\hat\theta_{ij2}/n_2} estimates the variance of
\eqn{\hat{\sigma}_{ij1}-\hat{\sigma}_{ij2}}.
The explicit formulas of \eqn{\hat\sigma_{ij1}}, \eqn{\hat\sigma_{ij2}},
\eqn{\hat\theta_{ij1}} and \eqn{\hat\theta_{ij2}} can be found
in Section 2 of Cai, Liu and Xia (2013).
With some regularity conditions, under the null hypothesis \eqn{H_{0c}: \mathbf{\Sigma}_1 = \mathbf{\Sigma}_2},
the test statistic \eqn{T_{CLX}-4\log p+\log\log p} converges in distribution to
a Gumbel distribution \eqn{G_{cov}(x) = \exp(-\frac{1}{\sqrt{8\pi}}\exp(-\frac{x}{2}))}
as \eqn{n_1, n_2, p \rightarrow \infty}.
The asymptotic \eqn{p}-value is obtained by
\deqn{p_{CLX} = 1-G_{cov}(T_{CLX}-4\log p+\log\log p).}
}
\examples{
n1 = 100; n2 = 100; pp = 500
set.seed(1)
X = matrix(rnorm(n1*pp), nrow=n1, ncol=pp)
Y = matrix(rnorm(n2*pp), nrow=n2, ncol=pp)
covtest.clx(X,Y)
}
\references{
Cai, T. T., Liu, W., and Xia, Y. (2013). Two-sample covariance matrix testing
and support recovery in high-dimensional and sparse settings.
\emph{Journal of the American Statistical Association}, 108(501):265–277.
}
