% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_km_survival}
\alias{f_plot_km_survival}
\title{Plot Kaplan-Meier Survival Curves (ggsurvplot)}
\usage{
f_plot_km_survival(PERSUADE)
}
\arguments{
\item{PERSUADE}{A PERSUADE object created by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}
}
\value{
A \code{ggsurvplot} object with KM curves, risk table, CI bands, and optional censor marks.
}
\description{
Generates Kaplan-Meier survival plots from a PERSUADE object using
\code{\link[survminer:ggsurvplot]{survminer::ggsurvplot()}}, automatically adapting to the number of groups.
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_km_survival(PERSUADE)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
