% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_hazard_with_models}
\alias{f_plot_hazard_with_models}
\title{Hazard Plot with Model Overlays}
\usage{
f_plot_hazard_with_models(PERSUADE)
}
\arguments{
\item{PERSUADE}{A PERSUADE object created by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}
}
\value{
A series of base R plots, one per group, with hazard overlays by model family.
}
\description{
Plots observed smoothed hazard estimates together with hazard predictions
from parametric, spline, and cure survival models (if fitted).
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_hazard_with_models(PERSUADE)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
