% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/24_NZV.R
\name{nzv}
\alias{nzv}
\title{Near-zero variance}
\usage{
nzv(db, sc = c(NA, NaN, Inf, -Inf))
}
\arguments{
\item{db}{Data frame of risk factors supplied for near-zero variance analysis.}

\item{sc}{Numeric or character vector with special case elements. Default values are \code{c(NA, NaN, Inf, -Inf)}.}
}
\value{
The command \code{nzv} returns the data frame with different matrices needed for identification of near-zero variables.
For details see Description section.
}
\description{
\code{nzv} procedure aims to identify risk factors with low variability (almost constants). Usually these risk factors are
expertly investigated and decision is made if they should be excluded from further modeling process. \cr
\code{nzv} output report includes the following metrics:
\itemize{
\item rf: Risk factor name.
\item rf.type: Risk factor class. This metric is always one of: \code{numeric} or \code{categorical}.
\item sc.num: Number of special cases.
\item sc.pct: Percentage of special cases in total number of observations.
\item cc.num: Number of complete cases.
\item cc.pct: Percentage of complete cases in total number of observations. Sum of this value and \code{sc.pct} is equal to 1.
\item cc.unv: Number of unique values in complete cases.
\item cc.unv.pct: Percentage of unique values in total number of complete cases.
\item cc.lbl.1: The most frequent value in complete cases.
\item cc.frq.1: Number of occurrence of the most frequent value in complete cases.
\item cc.lbl.2: The second most frequent value in complete cases.
\item cc.frq.2: Number of occurrence of the second most frequent value in complete cases.
\item cc.fqr: Frequency ratio - the ratio between the occurrence of most frequent and the second most frequent value in
complete cases.
\item ind: Indicator which takes value of \code{1} if the percentage of complete cases is less then 10\% and frequency ratio
(\code{cc.fqr}) greater than 19. This values can be used for filtering risk factors that need further expert
investigation, but user are also encourage to derive its own indicators based on reported
metrics.
}
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#artificially add some special values
loans$"Account Balance"[1:10] <- NA
rf.s <- nzv(db = loans, sc = c(NA, NaN, Inf, -Inf))
rf.s
}
