% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{Heatmap}
\alias{Heatmap}
\title{Heatmap}
\usage{
Heatmap(data, a, category = FALSE)
}
\arguments{
\item{data}{A csv file for one participant with multiple days' activity records from SenseWear. Data format refers to provided \code{sampledata}.}

\item{a}{The desired cutpoints of METs. Lower and upper limits must be specified. E.g. \code{a=c(0,3,5,7)}. 0 and 7 are the lower and upper limit, respectively.}

\item{category}{Default is FALSE which means treating METs as continuous. \code{category=TRUE} and a valid cutpoints \code{a} will categorize METs by \code{a}. If \code{category=TRUE} while no \code{a} is specified, METs will be treated as continuous.}
}
\value{
\code{graph}	A heatmap generated by \code{ggplot} with x axis Time and y axis Date
}
\description{
Generate a heatmap to show different activity intensities (in MET) at different time of different days.
}
\examples{
#Continuous METs
Heatmap(sampledata);
#Categorical METs with cutpoint 0,3,5,7
 Heatmap(sampledata,c(0,3,5,7),category=TRUE)
}

