% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASWR-package.R
\docType{data}
\name{biomass}
\alias{biomass}
\title{Beech Trees}
\format{
A data frame with 42 observations on the following 4 variables:
\describe{ \item{Dn}{diameter of the stem in centimeters}
\item{H}{height of the tree in meters} 
\item{PST}{weight of the stem in kilograms} 
\item{PSA}{aboveground weight in kilograms} 
}
}
\source{
\emph{Gobierno de Navarra} and \emph{Gestion Ambiental Viveros y
Repoblaciones de Navarra}, 2006.  The data were obtained within the European
Project FORSEE.
}
\description{
Several measurements of 42 beech trees (\emph{Fagus Sylvatica}) taken from a
forest in Navarra (Spain).
}
\examples{

plot(log(PSA) ~ log(Dn), data = biomass)

}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. (2008)
\emph{Probability and Statistics with R}. Chapman & Hall/CRC.
}
\keyword{datasets}
