% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplot.R
\name{multiplot}
\alias{multiplot}
\title{Complex Plot Arrangements for ggplot Objects}
\usage{
multiplot(..., plotlist = NULL, cols = 1, layout = NULL)
}
\arguments{
\item{...}{ggplot objects to be passed to the function}

\item{plotlist}{a list of ggplot plots to plot}

\item{cols}{number of columns in layout}

\item{layout}{a matrix specifying the layout}
}
\description{
Arrange multiple ggplot objects on graphics device
}
\examples{
p1 <- ggplot(data = HSWRESTLER, aes(x = skfat, y = hwfat)) + geom_point()
p2 <- ggplot(data = HSWRESTLER, aes(x = tanfat, y = hwfat)) + geom_point()
multiplot(p1, p2, cols = 2)
multiplot(p1, p2, cols = 2, layout=matrix(c(1, 0, 0, 2), byrow = TRUE, nrow = 2))

}
\seealso{
\code{\link{layout}}
}
\author{
Winston Chang <winston@stdout.org>
}
\keyword{programming}
