% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowflake_plot_weighted.R
\name{snowflake_plot_weighted}
\alias{snowflake_plot_weighted}
\title{Function to generate weighted origami plot}
\usage{
snowflake_plot_weighted(
  df,
  object,
  weight,
  min_value = NULL,
  pcol = rgb(0.2, 0.5, 0.5, 1),
  pfcol = rgb(0.2, 0.5, 0.5, 0.1),
  pcol2 = rgb(0.6, 0.3, 0.3, 1),
  pfcol2 = NULL,
  axistype = 1,
  seg = 4,
  pty = 16,
  plty = 1:6,
  plwd = 1,
  pdensity = NULL,
  pangle = 45,
  cglty = 1.4,
  cglwd = 0.1,
  cglcol = "#000000",
  axislabcol = "#808080",
  title = "",
  na.itp = TRUE,
  centerzero = TRUE,
  vlabels = NULL,
  vlcex = 1,
  caxislabels = seq(0, 1, by = 0.25),
  calcex = NULL,
  paxislabels = NULL,
  palcex = NULL
)
}
\arguments{
\item{df}{input dataframe in the required format}

\item{object}{the name of the row that user wants to plot}

\item{weight}{weight of each variable, sum up to 1}

\item{min_value}{auxiliary point in the graph, default is min(df)/2}

\item{pcol}{color of the line of the original polygon, default is rgb(0.2,0.5,0.5,1)}

\item{pfcol}{color to fill the area of the original polygon, default is rgb(0.2,0.5,0.5,0.1).}

\item{pcol2}{color of the line of the weighted polygon, default is rgb(0.6,0.3,0.3,1).}

\item{pfcol2}{color to fill the area of the weighted polygon, default is NULL.}

\item{axistype}{type of axes. 0:no axis label. 1:center axis label only. 2:around-the-chart label only. 3:both center and around-the-chart labels. Default is 1.}

\item{seg}{number of segments for each axis, default is 4.}

\item{pty}{point symbol, default is 16. 32 means not printing the points.}

\item{plty}{line types for plot data, default is 1:6}

\item{plwd}{line widths for plot data, default is 1}

\item{pdensity}{filling density of polygons, default is NULL}

\item{pangle}{angles of lines used as filling polygons, default is 45}

\item{cglty}{line type for radar grids, default is 1.4}

\item{cglwd}{line width for radar grids, default is 0.1}

\item{cglcol}{line color for radar grids, default is #000000}

\item{axislabcol}{color of axis label and numbers, default is #808080}

\item{title}{title of the chart, default is blank}

\item{na.itp}{logical. If true, items with NA values are interpolated from nearest neighbor items and connect them. If false, items with NA are treated as the origin. Default is TRUE.}

\item{centerzero}{logical. If true, this function draws charts with scaling originated from (0,0). If false, charts originated from (1/segments). Default is TRUE.}

\item{vlabels}{character vector for the names for variables, default is NULL}

\item{vlcex}{font size magnification for vlabels, default is 1}

\item{caxislabels}{center axis labels, default is seq(0,1,by = 0.25)}

\item{calcex}{font size magnification for caxislabels, default is NULL}

\item{paxislabels}{around-the-chart labels, default is NULL}

\item{palcex}{font size magnification for paxislabels, default is NULL}
}
\value{No return value, called for visualization}
\description{
Function to generate weighted origami plot
}
\details{
This is the alias version of origami_plot_weighted function.
}
\examples{
data(sucra)
snowflake_plot_weighted(sucra, object="Intravertical PGE2", weight = c(0.15,0.25,0.3,0.2,0.1))

}
