% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMetrics.R
\name{evalMetrics}
\alias{evalMetrics}
\title{Compute Selected Evaluation Metrics}
\usage{
evalMetrics(mat, type = c("accuracy", "precision", "recall"))
}
\arguments{
\item{mat}{Binary confusion \code{matrix} (2-by-2; see Examples).}

\item{type}{Target evaluation metric as \code{character}, defaults to
\code{"accuracy"}. Other available options are \code{"precision"} and \code{"recall"}.}
}
\value{
A single \code{numeric}.
}
\description{
Compute selected evaluation metrics for binary (i.e. two-class) confusion
matrices.
}
\examples{
in1 = matrix(c(96, 4, 8, 19), nc = 2L, byrow = TRUE)
rownames(in1) = c("Condition Positive", "Condition Negative")
colnames(in1) = c("Predicted Positive", "Predicted Negative")

evalMetrics(in1) # default: "accuracy"
evalMetrics(in1, "precision")
evalMetrics(in1, "recall")

in2 = matrix(c(26, 17, 7, 400), nc = 2, byrow = TRUE)
evalMetrics(in2, "precision")
evalMetrics(in2, "recall")

}
\references{
University of Michigan (2017) Applied Machine Learning in Python. Available
online: \url{https://www.coursera.org/learn/python-machine-learning/home/welcome}.
}
\author{
Florian Detsch
}
