% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{BreastCancerWI_df}
\alias{BreastCancerWI_df}
\title{Breast Cancer Wisconsin (Diagnostic)}
\format{
A data frame with 569 observations and 31 variables:
\describe{
  \item{diagnosis}{Diagnosis of the breast mass: malignant or benign (factor with 2 levels).}
  \item{radius_mean}{Mean radius of the mass (numeric).}
  \item{texture_mean}{Mean texture of the mass (numeric).}
  \item{perimeter_mean}{Mean perimeter of the mass (numeric).}
  \item{area_mean}{Mean area of the mass (numeric).}
  \item{smoothness_mean}{Mean smoothness of the mass (numeric).}
  \item{compactness_mean}{Mean compactness of the mass (numeric).}
  \item{concavity_mean}{Mean concavity of the mass (numeric).}
  \item{concave_points_mean}{Mean number of concave points on the mass contour (numeric).}
  \item{symmetry_mean}{Mean symmetry of the mass (numeric).}
  \item{fractal_dimension_mean}{Mean fractal dimension of the mass (numeric).}
  \item{radius_sd}{Standard deviation of the radius (numeric).}
  \item{texture_sd}{Standard deviation of the texture (numeric).}
  \item{perimeter_sd}{Standard deviation of the perimeter (numeric).}
  \item{area_sd}{Standard deviation of the area (numeric).}
  \item{smoothness_sd}{Standard deviation of the smoothness (numeric).}
  \item{compactness_sd}{Standard deviation of the compactness (numeric).}
  \item{concavity_sd}{Standard deviation of the concavity (numeric).}
  \item{concave_points_sd}{Standard deviation of the number of concave points (numeric).}
  \item{symmetry_sd}{Standard deviation of the symmetry (numeric).}
  \item{fractal_dimension_sd}{Standard deviation of the fractal dimension (numeric).}
  \item{radius_peak}{Worst (peak) value of the radius (numeric).}
  \item{texture_peak}{Worst (peak) value of the texture (numeric).}
  \item{perimeter_peak}{Worst (peak) value of the perimeter (numeric).}
  \item{area_peak}{Worst (peak) value of the area (numeric).}
  \item{smoothness_peak}{Worst (peak) value of the smoothness (numeric).}
  \item{compactness_peak}{Worst (peak) value of the compactness (numeric).}
  \item{concavity_peak}{Worst (peak) value of the concavity (numeric).}
  \item{concave_points_peak}{Worst (peak) number of concave points (numeric).}
  \item{symmetry_peak}{Worst (peak) value of the symmetry (numeric).}
  \item{fractal_dimension_peak}{Worst (peak) value of the fractal dimension (numeric).}
}
}
\source{
Data taken from the cases package. Original documentation available at:
https://archive.ics.uci.edu/ml/datasets/breast+cancer+wisconsin+(diagnostic).
}
\usage{
data(BreastCancerWI_df)
}
\description{
This dataset, BreastCancerWI_df, is a data frame containing diagnostic information
for 569 patients with breast cancer. The data includes features computed from
digitized images of fine needle aspirates (FNA) of breast masses, as well as
a diagnosis label indicating whether the mass is malignant or benign.
}
\details{
The dataset name has been kept as 'BreastCancerWI_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
OncoDataSets package and assists users in identifying its specific characteristics.
The original content has not been modified in any way.
}
