% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_taxa.R
\name{hill_taxa}
\alias{hill_taxa}
\title{Sparse implementation of Hill numbers}
\usage{
hill_taxa(x, q = 0, normalize = TRUE, base = exp(1))
}
\arguments{
\item{x}{A \link[base]{matrix}, \link[Matrix]{sparseMatrix} or \link[Matrix]{Matrix}.}

\item{q}{A wholenumber for 0, 1 or 2, default is 0.}

\item{normalize}{A boolean variable for sample normalization by column sums.}

\item{base}{Input for \link[base]{log} to use natural logarithmic scale, log2, log10 or other.}
}
\value{
A numeric vector with type double.
}
\description{
Computes the hill numbers for q is 0, 1 or 2.
Code is adapted from \link[hillR]{hill_taxa} and uses \link[Matrix]{sparseMatrix} in triplet format over the dense matrix.
The code is much faster and memory efficient, while still being mathematical correct.
}
\examples{
library("Matrix")

n_row <- 1000
n_col <- 100
density <- 0.2
num_entries <- n_row * n_col
num_nonzero <- round(num_entries * density)

set.seed(123)
positions <- sample(num_entries, num_nonzero, replace=FALSE)
row_idx <- ((positions - 1) \%\% n_row) + 1
col_idx <- ((positions - 1) \%/\% n_row) + 1

values <- runif(num_nonzero, min = 0, max = 1)
sparse_mat <- sparseMatrix(
  i = row_idx,
  j = col_idx,
  x = values,
  dims = c(n_row, n_col)
)

result <- OmicFlow::hill_taxa(
 x = sparse_mat,
 q = 2
)
}
\seealso{
\link[hillR]{hill_taxa}
}
