% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsd.R
\name{jsd}
\alias{jsd}
\title{Compute Jensen-Shannon Divergence from a Sparse Matrix.}
\usage{
jsd(x, weighted = TRUE, threads = 1)
}
\arguments{
\item{x}{A \link[Matrix]{sparseMatrix}.}

\item{weighted}{A boolean value, to use abundances (\code{weighted = TRUE}) or absence/presence (\code{weighted=FALSE}) (default: TRUE).}

\item{threads}{A wholenumber, the number of threads to use in \link[RcppParallel]{setThreadOptions} (default: 1).}
}
\value{
A column x column \link[stats]{dist} object.
}
\description{
Calculates the Jensen-Shannon divergence of a \link[Matrix]{sparseMatrix} pairwise for each column.
}
\details{
The Jensen-Shannon divergence between two probability distributions \eqn{A} and \eqn{B}, each of length \eqn{n}, is defined as:

\eqn{ d(A, B) = \frac{1}{2} D_{KL}(A \parallel M) + \frac{1}{2} D_{KL}(B \parallel M) }

where \eqn{M = \frac{1}{2} (A + B)} is the mixture distribution,
and \eqn{D_{KL}} is the Kullback-Leibler divergence.
When weighted is set to FALSE, counts are replaced by presence/absence data.
}
\examples{
library("OmicFlow")

metadata_file <- system.file("extdata", "metadata.tsv", package = "OmicFlow")
counts_file <- system.file("extdata", "counts.tsv", package = "OmicFlow")
features_file <- system.file("extdata", "features.tsv", package = "OmicFlow")
tree_file <- system.file("extdata", "tree.newick", package = "OmicFlow")

taxa <- metagenomics$new(
    metaData = metadata_file,
    countData = counts_file,
    featureData = features_file,
    treeData = tree_file
)

taxa$feature_subset(Kingdom == "Bacteria")
taxa$normalize()

jsd(taxa$countData)
}
\references{
Lin, J. (1991). Divergence measures based on the Shannon entropy. IEEE Transactions on Information Theory, 37(1), 145-151.
}
