% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Gorard}
\alias{Gorard}
\title{A function to compute Gorard's segregation index}
\usage{
Gorard(x)
}
\arguments{
\item{x}{an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
totals because this will be interpreted as a group}
}
\value{
A numeric vector containing Gorard's segregation index values for each group
}
\description{
Gorard's index is an alternative to \code{\link{ISDuncan}}'s 
index, which measures the dissimilarity between the distribution of a 
group and the total population.
}
\examples{
x <- segdata@data[ ,1:2]
Gorard(x)
}
\references{
Gorard S. (2000) \emph{Education and Social Justice}. 
Cardiff, University of Wales Press
}
\seealso{
One-group evenness indices: 
\code{\link{ISDuncan}}, \code{\link{Gini}}, \code{\link{Atkinson}}, 
\code{\link{HTheil}}, '\code{\link{ISWong}}, \code{\link{ISMorrill}},
\code{\link{ISMorrillK}}

Between groups dissimilarity indices: 
\code{\link{DIDuncan}}, \code{\link{Gini2}}, 
\code{\link{DIMorrill}}, \code{\link{DIMorrillK}}, \code{\link{DIWong}}
}
