test_that("EM returns a well-formed fit object", {
  set.seed(1)
  X <- c(rnorm(50, -2, 1), rnorm(50, 2, 1))

  fit <- EM(X, K = 2, max_iter = 200, tol = 1e-6)

  expect_true(is.list(fit))
  expect_true(all(c("mu", "sigma", "pi", "num_iteraciones", "posterior") %in% names(fit)))

  expect_length(fit$mu, 2)
  expect_length(fit$sigma, 2)
  expect_length(fit$pi, 2)

  expect_true(all(is.finite(fit$mu)))
  expect_true(all(is.finite(fit$sigma)))
  expect_true(all(is.finite(fit$pi)))

  expect_true(all(fit$sigma > 0))
  expect_equal(sum(fit$pi), 1, tolerance = 1e-10)
  expect_true(all(fit$pi >= 0))

  expect_equal(dim(fit$posterior), c(length(X), 2))
  expect_true(all(is.finite(fit$posterior)))
  expect_true(all(fit$posterior >= 0 & fit$posterior <= 1))

  rs <- rowSums(fit$posterior)
  expect_equal(rs, rep(1, length(X)), tolerance = 1e-8)
})
