% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_cate.r
\name{make_cate}
\alias{make_cate}
\title{Function to calculate the Causal Treatment Effect}
\usage{
make_cate(
  model,
  train_data,
  test_data,
  w,
  x,
  y,
  family = gaussian(),
  ntree = 100,
  mtry = 2,
  verbose = TRUE
)
}
\arguments{
\item{model}{A \code{model} object used for estimation.}

\item{train_data}{The training dataset.}

\item{test_data}{The test dataset.}

\item{w}{Set the treatment variable.}

\item{x}{set Independent variables for the model.}

\item{y}{Set the outcome variable.}

\item{family}{The family type for the model (e.g., 'binomial').}

\item{ntree}{Number of trees for the Random Forest model.}

\item{mtry}{Number of variables to consider at each tree split in the Random Forest model.}

\item{verbose}{Set TRUE to print the output on the console.}
}
\value{
An object containing the estimated causal treatment effect results.
}
\description{
Predicting conditional average treatment effect (CATE) on a new policy based on the training over an old policy
}
\references{
\itemize{
\item Athey, S., and Wager S. 2021. Policy Learning with Observational Data, Econometrica, 89, 1, 133–161.
\item Cerulli, G. 2021. Improving econometric prediction by machine learning, Applied Economics Letters, 28, 16, 1419-1425.
\item Cerulli, G. 2022. Optimal treatment assignment of a threshold-based policy: empirical protocol and related issues, Applied Economics Letters, DOI: 10.1080/13504851.2022.2032577.
\item Gareth, J., Witten, D., Hastie, D.T., Tibshirani, R. 2013. An Introduction to Statistical Learning : with Applications in R. New York, Springer.
\item Kitagawa, T., and A. Tetenov. 2018. Who Should Be Treated? Empirical Welfare Maximization Methods for Treatment Choice, Econometrica, 86, 2, 591–616.
}
}
