% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odata_query.R
\name{ODataQuery}
\alias{ODataQuery}
\title{ODataQuery}
\description{
R6 class that represents an OData query
}
\details{
This class has methods to build and navigate OData services:

\itemize{
\item Use methods such as \verb{$path()} and \verb{$get()} to find a path.
\item Use methods such as \verb{$select()} and \verb{$filter()} to make your query.
\item Use methods such as \verb{$retrieve()}, \verb{$all()} and \verb{$one()} to obtain
the results.
}
}
\examples{

## ------------------------------------------------
## Method `ODataQuery$new`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")

## ------------------------------------------------
## Method `ODataQuery$print`
## ------------------------------------------------

\dontrun{
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
service$print(10)$path("People")$print()
}

## ------------------------------------------------
## Method `ODataQuery$path`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")

## ------------------------------------------------
## Method `ODataQuery$get`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
russellwhyte <- people_entity$get("russellwhyte")

## ------------------------------------------------
## Method `ODataQuery$func`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
get_nearest_airport <- service$func('GetNearestAirport')
\dontrun{
get_nearest_airport(lat = 33, lon = -118)
}

## ------------------------------------------------
## Method `ODataQuery$query`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$query(filter = "FirstName eq 'scott'")$url

## ------------------------------------------------
## Method `ODataQuery$top`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$top(10)

## ------------------------------------------------
## Method `ODataQuery$skip`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$skip(10)

## ------------------------------------------------
## Method `ODataQuery$select`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$select("FirstName", "LastName")

## ------------------------------------------------
## Method `ODataQuery$filter`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$filter(FirstName.eq = 'Scott')

## ------------------------------------------------
## Method `ODataQuery$expand`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$expand("Friends")

## ------------------------------------------------
## Method `ODataQuery$orderby`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$orderby('Concurrency')
people_entity$orderby('-Concurrency')

## ------------------------------------------------
## Method `ODataQuery$search`
## ------------------------------------------------

service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$search('Boise')

## ------------------------------------------------
## Method `ODataQuery$compute`
## ------------------------------------------------

# Not really supported by this particular service.
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$compute(a = "5 MUL Concurrency")

## ------------------------------------------------
## Method `ODataQuery$retrieve`
## ------------------------------------------------

\dontrun{
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity$retrieve()
}

## ------------------------------------------------
## Method `ODataQuery$all`
## ------------------------------------------------

\dontrun{
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity$all()
people_entity$all(jsonlite_args = list(simplifyVector = False))
}

## ------------------------------------------------
## Method `ODataQuery$one`
## ------------------------------------------------

\dontrun{
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity$top(1)$one(default = NA)
}
}
\seealso{
\code{\link[=and_query]{and_query()}} for details.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{url}}{Generate (encoded) url}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ODataQuery$new()}}
\item \href{#method-print}{\code{ODataQuery$print()}}
\item \href{#method-path}{\code{ODataQuery$path()}}
\item \href{#method-get}{\code{ODataQuery$get()}}
\item \href{#method-func}{\code{ODataQuery$func()}}
\item \href{#method-query}{\code{ODataQuery$query()}}
\item \href{#method-top}{\code{ODataQuery$top()}}
\item \href{#method-skip}{\code{ODataQuery$skip()}}
\item \href{#method-select}{\code{ODataQuery$select()}}
\item \href{#method-filter}{\code{ODataQuery$filter()}}
\item \href{#method-expand}{\code{ODataQuery$expand()}}
\item \href{#method-orderby}{\code{ODataQuery$orderby()}}
\item \href{#method-search}{\code{ODataQuery$search()}}
\item \href{#method-compute}{\code{ODataQuery$compute()}}
\item \href{#method-retrieve}{\code{ODataQuery$retrieve()}}
\item \href{#method-all}{\code{ODataQuery$all()}}
\item \href{#method-one}{\code{ODataQuery$one()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a class representing a query.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$new(
  service,
  .resource = "",
  .query_options = list(),
  httr_args = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{service}}{The url of the endpoint to connect to.
This url should not end with backslash.}

\item{\code{.resource}}{Should not be used directly. Use $path() instead.}

\item{\code{.query_options}}{Should not be used directly.
Use methods such as $select(), $filter() and $query() instead.}

\item{\code{httr_args}}{Additional parameters to pass to httr::GET}

\item{\code{value}}{Read-only}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print query, useful when debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$print(top = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{top}}{Number of records to print.}

\item{\code{...}}{Additional parameters are passed to print}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
service$print(10)$path("People")$print()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-path"></a>}}
\if{latex}{\out{\hypertarget{method-path}{}}}
\subsection{Method \code{path()}}{
Supply path to the resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$path(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Components that lead to resource path}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Query an individual record by ID parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$get(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ID-parameters (named or unnamed)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
russellwhyte <- people_entity$get("russellwhyte")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-func"></a>}}
\if{latex}{\out{\hypertarget{method-func}{}}}
\subsection{Method \code{func()}}{
Path to an OData function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$func(fname, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fname}}{Name of the function}

\item{\code{...}}{Options passed to retrieve_data}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
closure
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
get_nearest_airport <- service$func('GetNearestAirport')
\dontrun{
get_nearest_airport(lat = 33, lon = -118)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-query"></a>}}
\if{latex}{\out{\hypertarget{method-query}{}}}
\subsection{Method \code{query()}}{
Supply custom query options that do not start with $
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$query(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Named lists where the names are custom query options}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$query(filter = "FirstName eq 'scott'")$url
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-top"></a>}}
\if{latex}{\out{\hypertarget{method-top}{}}}
\subsection{Method \code{top()}}{
Limit the number of results to n
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$top(n = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of records to return at most}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$top(10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-skip"></a>}}
\if{latex}{\out{\hypertarget{method-skip}{}}}
\subsection{Method \code{skip()}}{
Skip first few items
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$skip(n = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of items to skip}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$skip(10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-select"></a>}}
\if{latex}{\out{\hypertarget{method-select}{}}}
\subsection{Method \code{select()}}{
Select fields. If not present, all fields are returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$select(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Fields to select}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$select("FirstName", "LastName")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-filter"></a>}}
\if{latex}{\out{\hypertarget{method-filter}{}}}
\subsection{Method \code{filter()}}{
Apply filter to result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$filter(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Can be a raw odata query or query options. It's recommended to use
query options because these will automatically escape parameters.
The parameters are passed on to \code{and_query}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$filter(FirstName.eq = 'Scott')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-expand"></a>}}
\if{latex}{\out{\hypertarget{method-expand}{}}}
\subsection{Method \code{expand()}}{
Expand on expansion properties
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$expand(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Properties to extend on}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$expand("Friends")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-orderby"></a>}}
\if{latex}{\out{\hypertarget{method-orderby}{}}}
\subsection{Method \code{orderby()}}{
Order results by one or more keys
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$orderby(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Keys to order by. To order in descending order, the key can
be prefixed by a negative sign.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$orderby('Concurrency')
people_entity$orderby('-Concurrency')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-search"></a>}}
\if{latex}{\out{\hypertarget{method-search}{}}}
\subsection{Method \code{search()}}{
Search the entity
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$search(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{Search string as defined by the endpoint.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$search('Boise')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-compute"></a>}}
\if{latex}{\out{\hypertarget{method-compute}{}}}
\subsection{Method \code{compute()}}{
Compute properties

Add additional properties to query computed from other attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$compute(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Named list of properties to compute}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Not really supported by this particular service.
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity <- service$path("People")
people_entity$compute(a = "5 MUL Concurrency")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieve data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$retrieve(count = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{count}}{Whether to include a count of the total number of records}

\item{\code{...}}{Passed to retrieve_data}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity$retrieve()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-all"></a>}}
\if{latex}{\out{\hypertarget{method-all}{}}}
\subsection{Method \code{all()}}{
Retrieve all data pages

Return concatenation of value of all pages
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$all(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Passed to retrieve_all}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity$all()
people_entity$all(jsonlite_args = list(simplifyVector = False))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-one"></a>}}
\if{latex}{\out{\hypertarget{method-one}{}}}
\subsection{Method \code{one()}}{
Retrieve individual
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODataQuery$one(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Passed to retrieve_one}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
service <- ODataQuery$new("https://services.odata.org/V4/TripPinServiceRW")
people_entity$top(1)$one(default = NA)
}
}
\if{html}{\out{</div>}}

}

}
}
