% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Accuracy.R
\name{plot.Accuracy}
\alias{plot.Accuracy}
\title{plot method for \code{Accuracy} objects}
\usage{
\method{plot}{Accuracy}(x, lty = 1, digits = NULL, main = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{\link{Accuracy}}.}

\item{lty}{A vector of line types, see \code{\link{par}}.}

\item{digits}{Integer indicating the number of decimal places (round) or significant digits (signif) to be used.}

\item{main}{main title of the plot.}

\item{...}{Arguments to be passed to methods.}
}
\value{
OOB error and test error, misclassification rate (MR) for classification or mean square error (MSE) for regression.
}
\description{
Draw the error graph of class \code{ODRF} at different tree sizes.
}
\examples{
data(breast_cancer)
set.seed(221212)
train <- sample(1:569, 80)
train_data <- data.frame(breast_cancer[train, -1])
test_data <- data.frame(breast_cancer[-train, -1])

forest <- ODRF(diagnosis ~ ., train_data,
  split = "gini",
  parallel = FALSE, ntrees = 30
)
(error <- Accuracy(forest, train_data, test_data))
plot(error)

}
\seealso{
\code{\link{ODRF}} \code{\link{Accuracy}}
}
\keyword{forest}
\keyword{plot}
