% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NostalgiR.R
\name{nos.ecdf}
\alias{nos.ecdf}
\title{nos.ecdf text-based plot of an empirical CDF.}
\usage{
nos.ecdf(data, xlab = NULL, ratio = 0.25, width = round(options()$width *
  0.8), height = round(ratio * width), pch = "o")
}
\arguments{
\item{data}{A numeric vector containing the values to be plotted. \code{NA} and \code{NaN} are allowed, but are removed for the plot. Infinities will cause an error.}

\item{xlab}{Label of the x-axis of the plot.}

\item{ratio}{Coefficient that controls the aspect ratio of the plot.}

\item{width}{Width of the plot in points.}

\item{height}{Height of the plot in points.}

\item{pch}{A single-character plot symbol.}
}
\description{
Plots a text-based empirical cumulative distribution function.
}
\note{
Due to rounding to a relatively crude grid results can only be approximate. The equally spaced axis ticks, for example, may be non-equally spaced in the plot. Further, due to the crude grid also there might be several points per character. The function uses the same plotting symbol no matter how many points coincide on one character position.
}
\examples{
## Plot the empirical CDF of 10 random standard normal points with 'o' shaped points.
data <- rnorm(10)
nos.ecdf(data)

## Plot the empirical CDF of 100 random stanard normal points with '*' shaped points
data <- rnorm(100)
nos.ecdf(data,pch='*')
}
\author{
Hien D. Nguyen
}
\seealso{
\code{\link[stats]{ecdf}}, \code{\link[graphics]{plot}} and \code{\link[txtplot]{txtplot}}.
}

