% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLNHE.r
\name{HLNHE}
\alias{HLNHE}
\alias{dHL.nhe}
\alias{pHL.nhe}
\alias{qHL.nhe}
\alias{rHL.nhe}
\alias{hHL.nhe}
\title{Half-Logistic NHE(Nadarajah-Haghighi Exponential) Distribution}
\usage{
dHL.nhe(x, alpha, beta, lambda, log = FALSE)
pHL.nhe(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qHL.nhe(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rHL.nhe(n, alpha, beta, lambda)
hHL.nhe(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dHL.nhe}: numeric vector of (log-)densities
  \item \code{pHL.nhe}: numeric vector of probabilities
  \item \code{qHL.nhe}: numeric vector of quantiles
  \item \code{rHL.nhe}: numeric vector of random variates
  \item \code{hHL.nhe}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Half-Logistic NHE distribution.
}
\details{
The Half-Logistic NHE distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Half-Logistic NHE distribution has CDF:

\deqn{
F(x;\,\alpha,\beta,\lambda) = 
\frac{{1 - \exp \left[ {\lambda \left\{ {1 - {{(1 + \alpha x)}^\beta }} 
\right\}} \right]}}{{1 + \exp \left[ {\lambda \left\{ {1 - {{(1 + \alpha x)}
^\beta }} \right\}} \right]}} \, ;\quad x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The functions available are listed below:
\itemize{
  \item \code{dHL.nhe()} — Density function
  \item \code{pHL.nhe()} — Distribution function
  \item \code{qHL.nhe()} — Quantile function
  \item \code{rHL.nhe()} — Random generation
  \item \code{hHL.nhe()} — Hazard function
}
}
\examples{
x <- seq(0.1, 1, 0.1)
dHL.nhe(x, 1.5, 0.8, 2)
pHL.nhe(x, 1.5, 0.8, 2)
qHL.nhe(0.5, 1.5, 0.8, 2)
rHL.nhe(10, 1.5, 0.8, 2)
hHL.nhe(x, 1.5, 0.8, 2)

#Data
x <- windshield
#ML Estimates    
params = list(alpha =0.1649, beta=3.7152, lambda=0.5881)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pHL.nhe, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qHL.nhe, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dHL.nhe, pfun = pHL.nhe, plot=FALSE)
print.gofic(out)

}
\references{
Almarashi, A. M., Elgarhy, M., Elsehetry, M. M., Kibria, B. G., & Algarni, A. (2019). 
A new extension of exponential distribution with statistical properties
and applications. \emph{Journal of Nonlinear Sciences and Applications}, \bold{12}, 135--145.

Chaudhary, A.K., & Kumar, V.(2020). 
Half Logistic Modified Exponential Distribution:Properties and Applications. 
\emph{EPRA International Journal of Multidisciplinary Research (IJMR)},
\bold{6(12)},276--286. \doi{10.36713/epra3291} 
 
Joshi, R. K., & Kumar, V. (2020). 
Half Logistic NHE: Properties and Application. \emph{International Journal
for Research in Applied Science & Engineering Technology (IJRASET)}, \bold{8(9)},
742--753. \doi{10.22214/ijraset.2020.31557}

Nadarajah, S., & Haghighi, F. (2011). An extension of the exponential distribution. 
\emph{Statistics}, \bold{45(6)}, 543--558.
}
