% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{waste}
\alias{waste}
\title{Food waste survey}
\format{
A data frame with 180 rows (participants) and 77 columns (questions).
}
\source{
Héloïse BILLES and Amélie RATEAU, students at l'Institut Agro Rennes-Angers
}
\usage{
waste
}
\description{
These data were collected after a survey on food waste, with participants describing their habits.
}
\examples{
\dontrun{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(NaileR)
library(FactoMineR)
data(waste)
waste <- waste[-14]

res_mca_waste <- MCA(waste, quali.sup = c(1,2,50:76),
ncp = 35, level.ventil = 0.05, graph = FALSE)
res_hcpc_waste <- HCPC(res_mca_waste, nb.clust = 3, graph = FALSE)
don_clust_waste <- res_hcpc_waste$data.clust

intro_waste <- 'These data were collected
after a survey on food waste,
with participants describing their habits.'
intro_waste <- gsub('\n', ' ', intro_waste) |>
stringr::str_squish()

req_waste <- 'Please summarize the characteristics of each group.
Then, give each group a new name, based on your conclusions.
Finally, give each group a grade between 0 and 10,
based on how wasteful they are with food:
0 being "not at all", 10 being "absolutely".'
req_waste <- gsub('\n', ' ', req_waste) |>
stringr::str_squish()

res_waste <- nail_catdes(don_clust_waste,
num.var = ncol(don_clust_waste),
introduction = intro_waste, request = req_waste,
drop.negative = TRUE)
res_waste |> cat()
}
}
\keyword{datasets}
