#' Calculate Isotope-Based Recovery Efficiency (NRE15)
#' @description
#' The percent recovery of fertilizer-N in plant and/or soil components.
#' Formula: NRE15 = (TNdfF / FertN) * 100
#' @param TNdfF Total N derived from Fertilizer (vector).
#' @param FertN Fertilizer N input (numeric vector or single value).
#' @return A numeric vector of NRE15 percentages.
#' @examples
#' TNdfF <- c(5.5, 6.0, 4.8)
#' FertN <- 50
#' NRE15(TNdfF, FertN)
#' @export
NRE15 <- function(TNdfF, FertN) {
  if (any(FertN == 0)) stop("FertN cannot be zero.")
  return((TNdfF / FertN) * 100)
}