% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSR_metadata.R
\name{NSR_metadata}
\alias{NSR_metadata}
\title{Get NSR metadata}
\usage{
NSR_metadata(bibtex_file = NULL, ...)
}
\arguments{
\item{bibtex_file}{Optional output file for writing bibtex citations.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
List containing: (1) bibtex-formatted citation information, (2) information about NSR data sources, and (3) NSR version information.
}
\description{
Returns metadata on NSR including version and citation information
}
\note{
This function provides citation information in bibtex format that can be used with reference manager software (e.g. Paperpile, Zotero). Please remember to cite both the sources and the NSR, as the NSR couldn't exist without these sources!

This function is a wrapper that returns the output of the functions NSR_citations, NSR_sources, and NSR_version.
}
\examples{
{
metadata <- NSR_metadata()
}

}
