% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.the.best.R
\name{select.the.best}
\alias{select.the.best}
\title{NPI  for selecting the best group}
\usage{
select.the.best(data, S)
}
\arguments{
\item{data}{a list of numeric data vectors}

\item{S}{an index of the group in the data list to be considered as the best group}
}
\value{
NPI lower and upper probabilities for the event that the next future observation from the Sth group is greater than all future observations from the other groups.
}
\description{
NPI lower and upper probabilities for the event that the next future observation
from one (the Sth) group is greater than all future observations from the other groups.
}
\examples{
# NPI lower and upper probabilities for the event that
# the next future observation from group 2 is greater
# than all future observations from the other groups.

data(FourSources)

# Convert the dataframe to a list of groups
data2<-split(FourSources$value,FourSources$source)
select.the.best(data2, 2)
}
