% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funRMSE.R
\name{funRMSE}
\alias{funRMSE}
\alias{funMSE}
\alias{funMAE}
\alias{funWAE}
\title{Calculate the RMSE, MSE, MAE, and WAE Rounded to 4 digits}
\usage{
funRMSE(y_pred, y0, dgts = 4)

funMSE(y_pred, y0, dgts = 4)

funMAE(y_pred, y0, dgts = 4)

funWAE(y_pred, y0, dgts = 4)
}
\arguments{
\item{y_pred}{numeric vector of the predicted values}

\item{y0}{numeric vector of the observed values}

\item{dgts}{integer value for how many digits to round to}
}
\value{
A numeric value, either the RMSE, MSE, MAE, or WAE.
}
\description{
Calculate the Root Mean Squared Error (RMSE), the Mean Squared Error (MSE), 
the Mean Absoluter Error (MAE), and the Worst Absolute Error (WAE). The
result is rounded to 4 digits by default. Apply \code{na.rm = TRUE}
}
\examples{
y0 <- 1:19
y_pred <- y0 + rnorm(length(y0), sd = 0.3)
funRMSE(y_pred, y0)
funMSE( y_pred, y0)
funMAE( y_pred, y0)
funWAE( y_pred, y0)

}
