% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Net_based.R
\name{Net_based}
\alias{Net_based}
\title{Network-based Regularized Spectral Clustering.}
\usage{
Net_based(Adj, K, tau = NULL, itermax = 100, startn = 10)
}
\arguments{
\item{Adj}{An \eqn{n \times n} symmetric adjacency matrix with diagonals being \eqn{0} and positive entries
being \eqn{1}.}

\item{K}{A positive positive integer which is no larger than \eqn{n}. This is the predefined number
of communities.}

\item{tau}{An optional tuning parameter to add \eqn{J} to the adjacency matrix \eqn{A}, where \eqn{J} is a
constant matrix with all entries equal to \eqn{1/n}. The default value is the mean of nodes' degrees.}

\item{itermax}{\code{k-means} parameter, indicating the maximum number of
iterations allowed. The default value is 100.}

\item{startn}{\code{k-means} parameter. The number of times the algorithm should be run with different initial
centroids. The default value is 10.}
}
\value{
\item{estall}{A factor indicating nodes' labels. Items sharing the same label are in the same community.}
}
\description{
\emph{Network-based Regularized Spectral Clustering} is a spectral clustering with regularized
  Laplacian method, fully established in fully established in \emph{Impact of Regularization on Spectral Clustering}
  of Joseph & Yu (2016).
}
\examples{

# Simulate the Network
n = 10; K = 2;
theta = 0.4 + (0.45-0.05)*(seq(1:n)/n)^2; Theta = diag(theta);
P  = matrix(c(0.8, 0.2, 0.2, 0.8), byrow = TRUE, nrow = K)
set.seed(2022)
l = sample(1:K, n, replace=TRUE); # node labels
Pi = matrix(0, n, K) # label matrix
for (k in 1:K){
  Pi[l == k, k] = 1
}
Omega = Theta \%*\% Pi \%*\% P \%*\% t(Pi) \%*\% Theta;
Adj = matrix(runif(n*n, 0, 1), nrow = n);
Adj = Omega - Adj;
Adj = 1*(Adj >= 0)
diag(Adj) = 0
Adj[lower.tri(Adj)] = t(Adj)[lower.tri(Adj)]
Net_based(Adj, 2)
}
\references{
Joseph, A., & Yu, B. (2016). Impact of Regularization on Spectral Clustering.
  \emph{The Annals of Statistics}, 44(4), 1765-1791. \cr\doi{10.1214/16-AOS1447}\cr
}
