% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simBinaryCorr.B.R
\name{simBinaryCorr.B}
\alias{simBinaryCorr.B}
\title{Compute intermediate binary correlations for multivariate binomial data}
\usage{
simBinaryCorr.B(B.n.vec, B.prob.vec, CorrMat, no.rows, steps = 0.025)
}
\arguments{
\item{B.n.vec}{vector of number of trials}

\item{B.prob.vec}{vector of probabilities}

\item{CorrMat}{specified Correlation matrix}

\item{no.rows}{number of observations for generating Multivariate Binary data}

\item{steps}{Fraction of difference between the current and target matrix to be added in each iteration.}
}
\value{
intermediate multivariate binary Correlation matrix
}
\description{
This function implements Step 2 of the algorithm to calibrate the intermediate
latent-normal correlation matrix used to generate correlated binary
variables. For each pair of variables, it iteratively updates the latent correlation
so that, after (i) generating correlated binary data via \code{generate.binaryVar} and
(ii) mapping back to binomial outcomes via \code{BinToB}, the empirical correlation of
the resulting binomial pair matches the user-specified target correlation in
\code{CorrMat}. The calibrated pairwise latent correlations are then assembled into a
full intermediate matrix, which is adjusted to be positive definite if needed.
}
\examples{
n.vec <- c(3, 4)
p.vec <- c(0.5, 0.5)

M<- c(0.3, 0.2)
N <- diag(2)
N[lower.tri(N)] <- M
cmat<- N + t(N)
diag(cmat) <- 1
# In real data simulation, no.rows should set to 100000 for accurate data
# generation in the intermediate step
binObj = simBinaryCorr.B(B.n.vec = n.vec, B.prob.vec = p.vec, CorrMat = cmat,
no.rows = 20000, steps= 0.025)


}
