% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiClassROC.R
\name{multiroc}
\alias{multiroc}
\title{ROC Curves for Multi-Class Analysis}
\usage{
multiroc(y, x, k, type = c("OvO", "OvA"), plot = TRUE, data)
}
\arguments{
\item{y}{A string, dependent variable}

\item{x}{A vector of strings, independent variables}

\item{k}{The number of categories}

\item{type}{A string, "OvO" for one-vs-one, "OvA" for one-vs-all approach}

\item{plot}{A logical, TRUE for the plot of the curves, FALSE for the average AUC}

\item{data}{A data frame, the dataset to use}
}
\value{
plot with ROC curves using ggroc, pROC (if plot=TRUE) or the average AUC (if plot=FALSE)
}
\description{
Function 'multiroc' can be used for computing and visualizing Receiver Operating Characteristics (ROC) and Area Under the Curve (AUC) for multi-class classification problems. It supports both one-vs-one and one-vs-all approaches.
}
\examples{
multiroc(y="Species",
             x=c("Petal.Width","Petal.Length","Sepal.Width","Sepal.Length"),
             k=3, type=("OvA"),
             plot=TRUE,
             data=iris)
multiroc(y="Species",
             x=c("Petal.Width","Petal.Length","Sepal.Width","Sepal.Length"),
             k=3,
             type=("OvO"),
             plot=FALSE,
             data=iris)



}
